#ifndef _SMARTREF_H_
#define _SMARTREF_H_

/***********************************************************************
 AUTHOR: Srikanta Bedathur
 DESCRIPTION:
    Interfaces to Smart References.

    Copyright (C) 2004 Database Systems Lab, Supercomputer Education and
    Research Centre, Indian Institute of Science, Bangalore, INDIA.
                     http://dsl.serc.iisc.ernet.in

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
***********************************************************************/
#include "defines.h"
#include "sfxnode.h"
#include "s_man.h"

class Ref;
class WRef;

//Separate storage managers for leaf and internal node
//management.  
extern StorageManager <SfxNode,true> *leaf_sm;
extern StorageManager <SfxInternalNode,false> *internal_sm;


class Ref {
public:
  union{
    struct SfxNode* _leafpointee;
    struct SfxInternalNode* _intpointee;
  };//It could be SfxInternalNode or SfxNode
  bool     _pinned;
public:
  // NOTE: sum of the following should be = 32 bits
  SFXULONG _isleaf: 1;
  SFXULONG _fileid: 2; //not used now, but later on for indexes > 2GB
#ifndef SMALL_PAGE
  SFXULONG _blockid: 19; //to cover 2GB
  SFXULONG _recid: 10; //indicates the position of the record this ref points to
#else
  SFXULONG _blockid: 27; //to cover 2GB
  SFXULONG _recid: 2; //indicates the position of the record this ref points to
#endif
  
  
public:
  /////////////////////////////////////////////////////////////////////
  /// CONSTRUCTORS
  /////////////////////////////////////////////////////////////////////
  /// 1. FROM A POINTER
  Ref (const SFXULONG _pointer);
  /// 2. FROM ANOTHER REF
  Ref (const Ref& rhs);
  /// 3. FROM THE DATA
  Ref (SfxNode* ptr, SFXULONG recid, SFXULONG blockid, SFXULONG fileid, bool isleaf);
  
  /////////////////////////////////////////////////////////////////////
  /// OPERATORS
  /////////////////////////////////////////////////////////////////////
  /// 1. ASSIGNMENT FROM A POINTER
  Ref& operator=(SFXULONG rhs);
  /// 2. ASSIGNMENT FROM ANOTHER REF
  Ref& operator=(const Ref& _rhs);
  /// 3. CAST INTO A POINTER (ULONG)
  operator SFXULONG() const;

  // Uggh kludge...
  // following is only for leaf nodes
  const SfxNode* operator->();
  // This is for internal nodes;
  const SfxInternalNode* operator* ();


  
  // To get a writeable reference from this
  WRef update();

    
  ~Ref();

  virtual bool isleaf () const {
    return (_isleaf == 1);
  }


protected:
  //These two functions call the storage manager
  //to maintain the reference counts to the 
  //blocks
  virtual void decrementref()const;
  virtual void incrementref() const;
  
  // Request the storage manager to read the block from disk
  // and obtains the pointer to the SfxNode/SfxInternalNode object
  // from there, and sets to the pointee
  // Also sets the pinned status
  virtual void requestobject();
};

class WRef:public Ref {
private:
  WRef (const Ref& ref);
public:
  SfxNode* operator->();
  SfxInternalNode* operator*();
  ~WRef ();
  friend class Ref;
};

#endif
