/***********************************************************************
 AUTHOR: Srikanta Bedathur
 DESCRIPTION:
    Option processing functions.

    Copyright (C) 2004 Database Systems Lab, Supercomputer Education and
    Research Centre, Indian Institute of Science, Bangalore, INDIA.
                     http://dsl.serc.iisc.ernet.in

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
***********************************************************************/
#include <string>
#include "options.h"

string Options::datafile = "";
long Options::datasize = -1;
string Options::leafBasefile = "";
string Options::internalBasefile = "";
int Options::internalNodeSize = -1;
int Options::leafNodeSize = -1;
char* Options::sequence = NULL;

string Options::_optionsFilename = "";

 
void Options::read (string optionsFileName) {
  
  string buffer;
  string key;
  string value;
  
  _optionsFilename = optionsFileName;

  ifstream options (_optionsFilename.c_str(), ios::in);
  if (!options.is_open()) {
    cerr << "ERROR : Unable to open the options file" << endl;
    exit (-20);
  }
  options >> buffer;
  key = buffer.substr (0, buffer.find_first_of(":"));
  value = buffer.substr (buffer.find_first_of(":") + 1);
  
  assert (strcmp (key.c_str(), "datafile") == 0);
  datafile = value;
  
  /* datasize */
  options >> buffer;
  
  key = buffer.substr (0, buffer.find_first_of(":"));
  value = buffer.substr (buffer.find_first_of(":") + 1);
  
  assert (strcmp (key.c_str(), "datasize") == 0);
  datasize = atol (value.c_str());
  
  /* internalBasefile */
  options >> buffer;
  
  key = buffer.substr (0, buffer.find_first_of(":"));
  value = buffer.substr (buffer.find_first_of(":") + 1);
  
  assert (strcmp (key.c_str(), "internalBasefile") == 0);
  internalBasefile = value;  
  
  /* leafBasefile */
  options >> buffer;
  
  key = buffer.substr (0, buffer.find_first_of(":"));
  value = buffer.substr (buffer.find_first_of(":") + 1);
  
  assert (strcmp (key.c_str(), "leafBasefile") == 0);
  leafBasefile = value;  
  
  
  // internalNodeSize
  options >> buffer;
  
  key = buffer.substr (0, buffer.find_first_of(":"));
  value = buffer.substr (buffer.find_first_of(":") + 1);
  
  assert (strcmp (key.c_str(), "internalNodeSize") == 0);
  internalNodeSize = atol (value.c_str());
  
  
  // leafNodeSize
  options >> buffer;
  
  key = buffer.substr (0, buffer.find_first_of(":"));
  value = buffer.substr (buffer.find_first_of(":") + 1);
  
  assert (strcmp (key.c_str(), "leafNodeSize") == 0);
  leafNodeSize = atol (value.c_str());
}


const string Options::getLeafBasefile () {
  return Options::leafBasefile;
}


const string Options::getInternalBasefile() {
  return Options::internalBasefile;
}


