/***********************************************************************
 AUTHOR: Srikanta Bedathur
 DESCRIPTION:
    Internal node implementation for linked-list representation of nodes.

    Copyright (C) 2004 Database Systems Lab, Supercomputer Education and
    Research Centre, Indian Institute of Science, Bangalore, INDIA.
                     http://dsl.serc.iisc.ernet.in

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
***********************************************************************/

#ifdef LINKEDLIST
#include <iostream>
#include <assert.h>
#include "defines.h"
#include "sfxnode.h"
#include "smartref.h"
SfxInternalNode::SfxInternalNode ():SfxNode(){
  child = 0;
  suffixLink = 0;
#ifdef DEBUG
  numberofchildren = 0;
#endif
}

void SfxInternalNode::addChild (SFXULONG _cpointer, SFXULONG _myself) {
  // 1. If no child, then set it, set its parentflag/parent
  // 2. If there are children, then set this as the head of the list
  ASSERT (_cpointer != 0);
  Ref _temp (_cpointer);
  
  ASSERT (locateChild (_temp->getch()) == 0);

  if (child == 0) {
    (_temp.update())->setNextParentFlag (true);
    (_temp.update())->setNext (_myself);
  }
  else {
    Ref _temp (_cpointer);
    (_temp.update())->setNextParentFlag (false);
    (_temp.update())->setNext (child);
  }
  child = _cpointer;
#ifdef DEBUG
  numberofchildren++;
#endif
}

SFXULONG SfxInternalNode::removeChild(unsigned char _c){
  // Look through the child list for the node with _c 
  // and remove it.

  if (child == 0) 
    return 0;

#ifdef DEBUG
  ASSERT (numberofchildren > 0);
#endif

  Ref _child (child);

  ASSERT (_child->getNext () != 0);
  
  if (_child -> getNextParentFlag ()) {

#ifdef DEBUG
    ASSERT (numberofchildren == 1);
#endif
    
    if (_child->getch() == _c) {
      (_child.update())->setNext (0);
      (_child.update())->setNextParentFlag (false);
#ifdef DEBUG 
      numberofchildren--;
#endif
      child = 0;
      return (_child);
    }
  }
  else {

    if (_child->getch () == _c) {
      child = _child->getNext ();
      (_child.update())->setNext (0);
      (_child.update())->setNextParentFlag (false);
      return (_child);
    }

    Ref _prevchild (_child);
    _child = _child->getNext();
    
    while (true) {
      if (_child->getch () == _c) {
	(_prevchild.update())->setNext (_child->getNext());
	(_prevchild.update())->setNextParentFlag (_child->getNextParentFlag());
	(_child.update())->setNext (0);
	(_child.update())->setNextParentFlag (false);
#ifdef DEBUG
	numberofchildren--;
#endif
	return (_child);
      }
      _prevchild = _child;
      if (_prevchild->getNextParentFlag () == true)
	break;
      _child = _child->getNext();
    }
  }
  return 0;
}

SFXULONG SfxInternalNode::locateChild(unsigned char _c) const{

  if (child == 0)
    return 0;

  Ref _child (child);
  for ( ; 
	_child->getNextParentFlag () != true; 
	_child = _child->getNext()) {
    if (_child->getch () == _c)
      return _child;
  }
  if (_child->getch () == _c) 
    return _child;
  return 0;
}

SFXULONG SfxInternalNode::getChild () const {
  return child;
}

void SfxInternalNode::setSuffixLink (SFXULONG _sfx){
  ASSERT (suffixLink == 0);
  suffixLink = _sfx;
}

SFXULONG SfxInternalNode::getSuffixLink () const{
  return suffixLink;
}

void SfxInternalNode::print (const char* sequence, const int level) const {

#if 1
  SfxNode::print (sequence, level, false);
  //  cout << " -> " << getSuffixLink ();
#else
  int j;
  OFFSET(level-1);
  for (j = 0; j < 25 && j < length; j++)
    cout << sequence [begins+j];
//   if (j < length)
//     cout << "...[" << length << "]";
#endif
  cout << endl;
}

#endif
