/***********************************************************************
 AUTHOR: Srikanta Bedathur
 DESCRIPTION:
    Private implementation of Smart References.

    Copyright (C) 2004 Database Systems Lab, Supercomputer Education and
    Research Centre, Indian Institute of Science, Bangalore, INDIA.
                     http://dsl.serc.iisc.ernet.in

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
***********************************************************************/
#include "smartref.h"
// The private methods
void Ref::decrementref() const {
  ASSERT (_pinned);
  DBG_TRACE("Ref::decrementref() " << endl);

  if(isleaf())
    leaf_sm->dec_ref (_fileid,_blockid);
  else
    internal_sm->dec_ref (_fileid,_blockid);
}

void Ref::incrementref() const {
  ASSERT (_pinned);
  DBG_TRACE("Ref::incrementref() " << endl);
  if (isleaf())
    leaf_sm->inc_ref (_fileid,_blockid);
  else
    internal_sm->inc_ref (_fileid,_blockid);

}


// NOTE: the get_obj will also take care of initial 
// reference counting.
void Ref::requestobject() {
  ASSERT (!_pinned);
  DBG_TRACE ("Ref::requestobject() " << isleaf() << "- " <<_fileid << ", " << _blockid << " ," << _recid << endl);
  if (isleaf()){
    _leafpointee = leaf_sm->get_obj (_fileid, _blockid, _recid);
    ASSERT (_leafpointee);
  }
  else{
    _intpointee = internal_sm->get_obj (_fileid, _blockid, _recid);
    ASSERT (_intpointee);
  }
  _pinned = true;
}

WRef::WRef (const Ref& ref):Ref(ref) {
  // The reference counting is done in the Ref consructor
  ASSERT(_pinned);
  // We need to set the dirty flag of the block in the 
  // storage manager
  DBG_TRACE ("WRef::WRef() " << endl);
  if (isleaf())
    leaf_sm->dirtify (_fileid, _blockid);
  else
    internal_sm->dirtify (_fileid, _blockid);
}
