// File : global.h
// Created by Pradeep Shenoy (purdy@cse.iitb.ernet.in)
// Last Modified 18 Aug 1999
// Description:
//    Part of the program implementing the VIPER algorithm
//    Contains the global variables/decls and a $Global$ class that has some
// globally used routines

#ifndef _global_h
#define _global_h

#pragma interface

#include <iostream.h>
#include <unistd.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <strings.h>
#include <assert.h>
#include <time.h>
#include <fcntl.h>
#include <stdlib.h>

// vars used in rule generation and pruning:
extern int DEBUG;
extern float Positive, Negative, MINCONF;
extern int CASE, ALLRULE;

struct Cand_t{

    int frequency;   // Counter 
    int lastTID;

    ushort genID1, genID2;   // Lower level generators.

    int *itemset;         // the actual itemset
    ushort localID; // ID at this level
    int *DAGchildren;	  // Downward pointers

    Cand_t **DAGparents;      // Upward pointers
    ushort numparents; 
    ushort updated;
    ushort WriteID;

    
};


extern char *STORDATA;	// These are defined in the main file.
extern char *READDATA;

extern char *DATAFILE;

class Global{

    static time_t lasttime;
    static time_t start_time;
    static unsigned long startmem;

    static int MinTransCount;

    // static int LEVEL; 

    static int snake_bufsize;
    static int snake_indxbufsize;
    static long maxdu;


public:
    static long diskUsage;

    static int MAXSN;	
    static float SUPP;
    static int  MAX_TLEN;  	
    static int MAXTID;	

    static int getnitems(void){ return MAXSN;}
    static float getminsup(void) { return SUPP;}
    static int getntrans(void) { return MAXTID;}
    static int getSnakeBufSize(void){
	return snake_bufsize;
    }
    static int getIndxBufSize(void){
	return snake_indxbufsize;
    }

    static int hasMinSup(int freq){ 
	if (MinTransCount == 0){
	    double x = MAXTID*SUPP; //modified by Vikram to remove
	    	    	    	    //borderline errors
	    MinTransCount = ((int)(x) < x)? ((int)(x))+1 : (int)(x);
	}
	return freq >= MinTransCount;
    }

    static void flip_files(void){

	struct stat maxdustat;
        long tmpdu = 0;
	if (stat(STORDATA, &maxdustat) >= 0)
	    tmpdu += maxdustat.st_blocks;
	if (stat(READDATA, &maxdustat) >= 0)
	    tmpdu += maxdustat.st_blocks;

	if(tmpdu > maxdu) maxdu = tmpdu;

	char *tmp = STORDATA; STORDATA = READDATA; READDATA = tmp;
    }

    static void time_step(int mark, char *mesg){
	if (mark == 0)// set the time.
	    lasttime = time(NULL);
	else  // Display a time step.
	    cout << mesg << time(NULL) - lasttime << endl;
    }

    static void statusbar(char *mesg){
	cout << mesg ;
	cout << " time " <<  time(NULL) - start_time;
	cout << " Mem used " << ((unsigned long) sbrk(0) - startmem)/1000000 << "M";
	cout << endl;
    }

    static void debug_print(char *s){
	cout << s << endl;
    }

    static void debug_dumparray(Cand_t *array, int size, int itemlen, char *mesg){
	for (int i = 0; i < size; i++){
	    cout << mesg;
	    for (int j = 0; j <itemlen; j++)
		cout << " " << array[i].itemset[j];
	    cout << "Freq = " << array[i].frequency;
	    cout << endl;
	}
    }

    static void printResult(void){

	char resultbuf[1024];
	sprintf(resultbuf, 
	    "RESULT: %s %f %ld\n", DATAFILE, SUPP, 
		    time(NULL) - start_time);

	cout << resultbuf;

	FILE *fptr = fopen("viper.log", "a");
	fprintf(fptr, resultbuf);
	fclose(fptr);

    }
    static void init_program(char *initfile){

	char buf[512];
	int N_TUPLES;
    
	FILE *fp = fopen(initfile, "r");
    
	fgets(buf, sizeof(buf), fp);	// Ignore alternate lines.
	fscanf(fp, "%d\n", &N_TUPLES);
	
	fgets(buf, sizeof(buf), fp);
	fscanf(fp, "%d\n", &MAXSN);
	
	fgets(buf, sizeof(buf), fp);
	fscanf(fp, "%d\n", &MAX_TLEN);  
	
	fgets(buf, sizeof(buf), fp);
	// fscanf(fp, "%f\n", &SUPP); will take supp as cmdline
	fgets(buf, sizeof(buf), fp);

	fgets(buf, sizeof(buf), fp);
	fscanf(fp, "%f\n", &MINCONF); 
	
	fgets(buf, sizeof(buf), fp);
	fscanf(fp, "%d\n", &snake_bufsize);

	fgets(buf, sizeof(buf), fp);
	fscanf(fp, "%f\n", &Positive);
	fgets(buf, sizeof(buf), fp);
	fscanf(fp, "%f\n", &Negative);

	fgets(buf, sizeof(buf), fp);
	fscanf(fp, "%d\n", &CASE);
	fgets(buf, sizeof(buf), fp);
	fscanf(fp, "%d\n", &ALLRULE);

	Global::snake_indxbufsize = 256;
	// Will change this to a computation later.
    
	cout<< "Starting the Viper Algorithm..." << endl;
	fclose(fp);

	Global::start_time = time(NULL);
	Global::startmem   = (unsigned long) sbrk(0);
	Global::MinTransCount = 0;
	Global::diskUsage = 0;
	Global::maxdu = 0;

	return;
    }

};

#endif  // #ifndef _global_h
