// File:  snakes.C 
// Created by: Pradeep Shenoy (purdy@cse.iitb.ernet.in)
// Last modified: 19 Aug 1999
//
// Description: 
// 	The code for the snake input and output classes. 
// (refer snakes.h for a brief description)

#pragma implementation

#include <unistd.h>
#include <sys/mman.h>
#include <stdio.h>
#include <errno.h>
#include "include/snakes.h"

// Local variables ...
const int firstbit = 1 << 7;

long du_count;

// Fill up the data buffer with the snake's next buffer in the disk.
inline int RSN::readbuf(){
    
    if (nextbuf_offset < 0) return 0; // End of data
    
    lseek(readfd, SN_BUFSIZ*nextbuf_offset, SEEK_SET);
    read(readfd, data_buf, SN_BUFSIZ);
    du_count ++;
    
    // Take the last 4bytes as pointer to the next buffer
    nextbuf_offset = 0;
    for (int i = 0; i < 4; i++)
    	nextbuf_offset += (data_buf[SN_BUFSIZ-4+i] << (8*i));
    
    // Incase this is the last block.
    // Basically nextbuf_offset also doubles as the negative 
    // of the number of bytes filled in the last buffer.

    if (nextbuf_offset < 0) curr_lim = -(nextbuf_offset);
    
    return 1;
}


// Initialise the class instance. $initOffs$ is the pseudo-id given to the
// snake, and is the offset at which the first buffer of this snake is to be
// found in the common file.
void RSN::init_read(int fd, int initOffs){
    
    readfd = fd;
    initoffs = nextbuf_offset = initOffs;
    
    data_buf = new unsigned char[SN_BUFSIZ];
    
    // Internal variables;
    offset = 8; pos = 0;
    curr_lim = SN_BUFSIZ-4; // last4 bytes used for ptr
    getnext_done = readbit_done = TID = 0;
    
    readbuf();
}

// Decompress routine  -- look at snakes.h for description.

inline int RSN::readbit(){
    
    if (readbit_done) return 0;
    
    if (!offset){
    	if (pos+1 < curr_lim)pos++;
    	else{
	    if ((readbit_done = !readbuf())) return 0;
	    pos = 0;
	}
	offset = 8;
    }
    
    int bit = (data_buf[pos] & (1 << --offset))? 1 : 0;
    return bit;
}

int RSN::getNextTid() {
    
    int nzeros = 0, remainder = 0;
    
    if (getnext_done) return (TID = -1);
    
    if (readbit())
	return ++TID;
    
    while(readbit()) nzeros++;
    
    for (int i = 7; i >= 0; i--) 
    	remainder |= readbit() << i;
    
    if ((getnext_done = !readbit())) return (TID = -1);
    
    return TID += nzeros*256 + remainder + 1;
    
}


// Flush current buffer to disk at (already allocated) offset. Also allocate
// offset ( = current EOF) as the next position for writing.

inline void WSN::writebuf(int nextptr){
    
    // Tag it with the next reserved buf-index (saved in last 4bytes)
    for (int i = 0; i < 4; i++)
	data_buf[SN_BUFSIZ-4+i] = (nextptr&(0xff<<(8*i)))>>(8*i);
    
    lseek(writefd, writeOffs*SN_BUFSIZ, SEEK_SET);
    write(writefd, data_buf, SN_BUFSIZ);

    du_count++;
    writeOffs = nextptr;  // For next time.
}

// Initialise the class instance. $glob_bc$ is a variable that is common
// across all the class instances in an invocation. This helps to
// allocate the file buffer positions on fcfs basis to all snakes.

void WSN::init_write(int fd, int initOffs_a, int *glob_bc){
    
    // File descriptor
    writefd = fd;
    initoffs = writeOffs = initOffs_a;
    
    // current buffernumber in common snake file.
    global_buffer_count = glob_bc;
    
    // Internal vars
    pos = 0; offset = 8;
    lastTID = 0;
    
    // Initialise the first buffer
    data_buf = new unsigned char[SN_BUFSIZ];
    data_buf[0] = 0;
}

WSN::~WSN(){
    
    if (saveLastBlock)
	writebuf(-(++pos)); // Save #bytes used in lastblk.
    
    delete [] data_buf;
}

// Add bit -- compression routine.
inline void WSN::writebit(int what){
    
    int bit = (what)? 1 : 0;
    if (offset);
    else { 
	if (pos+1 < SN_BUFSIZ-4) pos++; 
	else{
	    writebuf(++(*global_buffer_count)); pos = 0;
	}
	data_buf[pos] = 0;
	offset=8;
    }
    data_buf[pos] |= bit <<--offset;
}

int WSN::addToSnake(int TID){
    
    int nzeros, rem;
    
    int gap = TID - lastTID - 1;
    lastTID = TID;
    
    if (!gap){
	writebit(1); return 0;
    }
    
    writebit(0);
    
    nzeros = gap/256;
    rem = gap%256;
    while(nzeros--) writebit(1);
    writebit(0);
    
    for (int i = 0; i < 8;i++, rem<<=1) writebit(rem & firstbit); 
    writebit(1);
    
    
    return 0;
}

