/**********************************************************************
    Copyright (C) 2004 Database Systems Lab, Supercomputer Education and
    Research Centre, Indian Institute of Science, Bangalore, INDIA.
    http://dsl.serc.iisc.ernet.in

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
***********************************************************************/


/***********************************************************************
 An itemset with count information is refered to as a cItemset.  Also a
 hashtree which contains such cItemsets is called a cHashtree, and a
 vector of cItemsets is called as a cItemsetBag.  These are just for
 convenience.  These declarations are placed in a seperate file than
 apriori.h since they may be useful even if one is not concerned with
 apriori.
***********************************************************************/
#ifndef CITEMSET_H_
#define CITEMSET_H_

#include "item.h"
#include "hashtree.h"

typedef HashTree<Itemset,int> cHashtree;
typedef pair<Itemset,int> cItemset; //itemset with count
typedef vector<cItemset> cItemsetBag;

// ADDED FOR MASK

/*
typedef vector<int> pcounts;
typedef pair<Itemset,pcounts> vItemset;
typedef HashTree<Itemset,pcounts> vHashtree;
*/
/*
typedef pair<Itemset,int*> vItemset;
typedef HashTree<Itemset,int*> vHashtree;
*/

// 
// inline void input(istream& s, cHashtree& h, int mincount)
// {
//     int no_items;
//     s >> no_items;
// 
//     if (! s)
// 	return;
// 
//     int noItemsets;
//     s >> noItemsets;
// 
//     if (! s)
// 	return;
// 
//     h.setNoItems(no_items);
//     cHashtree::Entry e;
//     while (s >> e.first)
//     {
// 	if (e.first.size() != 0)
// 	{	    
// 	    char skip;
// 	    s >> skip; //skip :
// 	    s >> e.second;
// 	    if (e.second >= mincount)
// 	    {
// 		e.second = 0;
// 		h.move(e);
// 	    }
// 	}
//     }
// 
//     return;
// }

#endif
