/**********************************************************************
    Copyright (C) 2004 Database Systems Lab, Supercomputer Education and
    Research Centre, Indian Institute of Science, Bangalore, INDIA.
    http://dsl.serc.iisc.ernet.in

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
***********************************************************************/


/***********************************************************************
 Just a generic functor (See the latest C++ book) to print the contents
 of a structure onto a given stream.  It uses the << operator and so
 that operator must have been defined for that structure.  The use of
 defining this functor is to pass it as an argument to a traversal
 routine which can then print all the contents of the container that is
 traversed.
***********************************************************************/
#ifndef GENPRINT_H_
#define GENPRINT_H_

#include "function.h"
#include <iostream.h>

template<class T> struct print : public unary_function<T, void>
{
  print(ostream& out) : os(out) {}
  void operator() (T x) { os << x; }
  ostream& os;
};

#endif
