/**********************************************************************
    Copyright (C) 2004 Database Systems Lab, Supercomputer Education and
    Research Centre, Indian Institute of Science, Bangalore, INDIA.
    http://dsl.serc.iisc.ernet.in

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
***********************************************************************/


/******************************* Item **********************************
 The set of possible items in the database is assumed to be mapped from
 0 to some max-1 and it is the responsibility of database.h to convert
 the values in the database to values in that range before passing them
 on to other layers of the code, if they are not already in that
 range.  Item could have been defined as an int.  But out of regard for
 strong typing in C++, a seperate structure has been defined for it. 
 As expected, this structure contains nothing more than a single int
 representing the id of that item.

 Only the operators < and == have been defined for items.  Other
 operators can always be defined based on these.  Infact this has been
 done and commented out, since it was not necessary and may mess with
 other uses of these operators.  Besides these the i/o operators << and
 >> have been defined.

 A sorted vector (svector) of Items is referred to as an Itemset.  An
 itemset could have been defined as a linked list instead of a vector,
 to facilitate insertion and deletion from within.  This is necessary
 in functions AprioriGen (apriori.h) and other places.  However since
 not much gain was obtained from this, the more consise vector was
 used.  Savings in space may be more useful because in some cases the
 number of itemsets that need to be in memory is very large.
***********************************************************************/
#ifndef ITEM_H_
#define ITEM_H_

#include "svector.h"

struct Item
{
    int id; //the item id

    Item() { }
    Item(int i) { id = i; }
    Item& operator=(int i) { id = i; return *this; }
//    operator int() const { return id; } //see section 11.4 of
    					 //Stroustrup, 3ed.
    bool operator<(const Item& i) const { return (id < i.id); }
    bool operator==(const Item& i) const { return (id==i.id); }
};

//----------------- comparison operations -------------
// inline bool operator==(const Item& i1, const Item& i2)
//     { return (i1.id==i2.id); }
// inline bool operator!=(const Item& i1, const Item& i2)
//     { return (!(i1==i2)); }
// inline bool operator<(const Item& i1, const Item& i2)
//     { return (i1.id < i2.id); }
// inline bool operator>(const Item& i1, const Item& i2)
//     { return (i2<i1); }
// inline bool operator<=(const Item& i1, const Item& i2)
//     { return (!(i1>i2)); }
// inline bool operator>=(const Item& i1, const Item& i2)
//     { return (!(i1<i2)); }

//--------------------- i/o operations ----------------
inline ostream& operator<<(ostream& s, const Item& i)
	{ return (s<<i.id); }
inline istream& operator>>(istream& s, Item& i)
	{ return (s>>i.id); }

//***************************** Itemset ********************************
typedef svector<Item> Itemset;


#endif


