/**********************************************************************
    Copyright (C) 2004 Database Systems Lab, Supercomputer Education and
    Research Centre, Indian Institute of Science, Bangalore, INDIA.
    http://dsl.serc.iisc.ernet.in

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
***********************************************************************/


/******************************** Tidlist ******************************
 Some algorithms such as AprioriTid and PARTITION rely on tidlists.  A
 tidlist is actually the sequence of ids of those transactions which
 contain a particular item or itemset.
 
 The readPartition() function reads a partition of the database of size
 sz and converts it into a set of tidlists -- one tidlist for each
 item. Such a set of tidlists is represented by a TidlistBag which is
 nothing more than a vector of Tidlists.  A tidlist itself is
 implemented by a simple vector of integers.  (Hence transaction ids
 are assumed to be no larger than what can fit in an integer.)
***********************************************************************/
#ifndef TIDLIST_H
#define TIDLIST_H

#include "database.h"

typedef vector<int> Tidlist;
typedef vector<Tidlist> TidlistBag;

int readPartition(Database& db, int sz, TidlistBag& bag)
{
    bag.resize(db.columns());

    int count = 0;
    Itemset i;
    while (count < sz && (db >> i)) //don't use for loop here
    {
	for (Itemset::const_iterator j = i.begin(); j != i.end(); j++)
	    bag[j->id].push_back(count);
	count++;
    }

    return count;
}

int readPartition(ItemsetBag& db, int sz, TidlistBag& bag)
{
    bag.resize(db.columns());

    int count = 0;
    Itemset i;
    while (count < sz && (db >> i)) //don't use for loop here
    {
	for (Itemset::const_iterator j = i.begin(); j != i.end(); j++)
	    bag[j->id].push_back(count);
	count++;
    }

    return count;
}

#endif
