/**********************************************************************
    Copyright (C) 2004 Database Systems Lab, Supercomputer Education and
    Research Centre, Indian Institute of Science, Bangalore, INDIA.
    http://dsl.serc.iisc.ernet.in

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
***********************************************************************/


/************************* Triangular Array ****************************
 A triangular array of integers.  Ofcourse it can be easily converted
 to a template to hold objects other than integers, but this has not
 been necessary so far.  The implementation is quite straight-forward.

 The main member functions are at(n,m) which returns the element in the
 nth row, mth column, and setdata(n,m,value) which sets the value of
 the element in the nth row, mth column to 'value'.

 A swap() member function is provided to swap the contents of the
 triangular array with another.

 Input operator >> is defined.  For output, a function output() is
 provided, which is rather a hack of sorts.

 Details of the Hack: This triangular array has been used so far only
 to hold counts of 2-itemsets that are either large or in the negative
 border.  While outputting, we need not output those itemsets that have
 been determined to be neither large or in the negative border.  So
 this output() function takes a vector of indices (which are actually
 the identities of large 1-itemsets -- see file nbgen.h) and doesn't
 output any itemsets in a row or column of the triangular array, if the
 corresponding index has been marked as -1.  Some day this hack must be
 gotten rid of, and a decent output operator defined.
***********************************************************************/
#ifndef TRIANGLE_H_
#define TRIANGLE_H_

#include <fstream.h>

class Triangular_array
{
    vector<int> data;
    int width;

public:

    Triangular_array() : data(0), width(0) { }
    Triangular_array(int i) : data(i*(i-1)/2), width(i) { }

    int at(int n, int m)
	{ return (data[n*(width-1) - n*(n+1)/2 + m - 1]); }
    void setdata(int n, int m, int value)
        { data[n*(width-1) - n*(n+1)/2 + m - 1] = value; }
    void increment(int n, int m)
        { data[n*(width-1) - n*(n+1)/2 + m - 1] ++ ; }
    int size() { return (data.size()); }
    int columns() { return width; }
    void resize(int i) { data.resize(i*(i-1)/2); width = i; }
    void clear() { data = vector<int>(); width = 0; }
    friend istream& operator>>(istream& s, Triangular_array& T);
    void output(ofstream& outfile, vector<int>& indices)
    {
	int noLarge1 = 0;
	int p;
	for (p = 0; p < (int)indices.size(); p++)
	    if (indices[p] != -1)
		noLarge1++;
	outfile << "\n" << noLarge1 << "\n";
	int no2 = 0;
	for (p = 0; p < (int)indices.size()-1; p++)
	{
	    if (indices[p] == -1)
		continue;
	    for (int q = p+1; q < (int)indices.size(); q++)
		if (indices[q] != -1) {
		    outfile << " " << at(indices[p],indices[q]);
		    no2++;
		}
	}
	cout << "\nNumber of 2-itemsets: " << no2 << endl;
    }
    void swap(Triangular_array& T)
    {
	int w = width;
	width = T.width;
	T.width = w;
	data.swap(T.data);
    }
};

istream& operator>>(istream& s, Triangular_array& T)
{
    s >> T.width;
    T.resize(T.width);
    vector<int>::iterator i;
    for (i = T.data.begin(); i != T.data.end(); i++)
	s >> *i;
    return s;
}

#endif
