/**********************************************************************
    Copyright (C) 2004 Database Systems Lab, Supercomputer Education and
    Research Centre, Indian Institute of Science, Bangalore, INDIA.
    http://dsl.serc.iisc.ernet.in

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
***********************************************************************/


/***********************************************************************
 ItemsetBag is a class based on similar lines as that of the Database
 class (database.h).  That is, it can be used as if it were a stream of
 Itemsets. So if x is an ItemsetBag we can say something like --

    Itemset i;
    while (x >> i)
	etc.

 Infact this class can be used wherever the Database class can be
 used.  So it is used, for example, to read a portion of a database
 into an ItemsetBag and then apply the Apriori algorithm on this
 ItemsetBag as though it were the database.  No change (atleast not
 much!) needs to be made to the implementation of the Apriori algorithm
 to accomplish this.

 ItemsetBag is implemented as a vector of Itemsets.
***********************************************************************/
#ifndef ITEMSETBAG_H_
#define ITEMSETBAG_H_

#include "item.h"

class ItemsetBag : public vector<Itemset>
{
    int noAttributes; //no of attributes
    int cursor;

public :

    int rows() const { return size(); }
    int columns() const { return noAttributes; }
    void setColumns(int i) { noAttributes = i; }

    void rewind() { cursor = -1; } //goto first tuple
    int tell() { return cursor; } //return current position
    void seek(int p) { cursor = p; }
    	//go to position marked using tell()

    void skip() { cursor++; } //skip the next tuple
    friend ItemsetBag& operator>>(ItemsetBag& d, Itemset& i);
    	//operator gets the next tuple and puts it into itemset i

    operator bool() { return (cursor < (int)size()); }
    	//returns true if the input stream is good(), i.e. the previous
    	//input worked.
    	//See sections 7.3.2 and 10.3.2 of Stroustrup 2nd edition and
    	//21.3.3 of 3rd edition.
        //Should have been a const function. But good() is not
    	//implemented as a const function.. so

};

ItemsetBag& operator>>(ItemsetBag& d, Itemset& i)
{
    if (++d.cursor < (int)d.size())
	i = d[d.cursor];
    return d;
}

#endif
