/**********************************************************************
    Copyright (C) 2004 Database Systems Lab, Supercomputer Education and
    Research Centre, Indian Institute of Science, Bangalore, INDIA.
    http://dsl.serc.iisc.ernet.in

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
***********************************************************************/


#include <stdio.h>
#include <float.h>
#include <math.h>

double** allocate_mat(int n);
//double determenant(double** a,int n);
double determenant(double** a,int n);
double** Inverse(double** a,int n);
void adjoint(double** ,double** ,int);
void formdet(double** a,double** c,int rw,int cl,int n);
void printmat(double** a,int n);

double** allocate_mat(int n)
{
	double** arr = new double*[n];
 	for(int i=0;i<n;i++)
    	        arr[i] = new double[n]; 
	return(arr);
}

/*
void main()
{
  	double** a;
  	double** b;
  	int i,j,n;

	printf("\n n= ");
 	scanf("%d",&n);

	a=allocate_mat(n*n);
  
  	for(i=0;i<n;i++)
		for(j=0;j<n;j++) 
			scanf("%f",*(a+i)+j);
	printf("\n A= ");
	printmat(a,n);
 	printf("det of A = %7.4f",determenant(a,n));

  	b=Inverse(a,n);
  	printf("\n A inverse =");
  	printmat(b,n);
}
*/


void destroy(double** arr, int n)
{
	int i;
        for(i=0;i<n;i++)
        	delete[] arr[i];

       	delete[] arr;
}




	

void printmat(double** a,int n)
{
  int i,j;
  for(i=0;i<n;i++)
  {  
	printf("\n");
    	for(j=0;j<n;j++)
		printf("%7.4f  ",a[i][j]/*(*(a+i)+j)*/);
  }
  printf("\n");
}


double** Inverse(double **a,int n)
{
	int i,j;
	double det;
	double** b=allocate_mat(n*n);	

	adjoint(a,b,n);
	det=determenant(a,n);
   
   	if(det==0)
   	{ 
		printf("Det=0");
		exit(1);
	}
   	else
	{
	for(i=0;i<n;i++)
      		for(j=0;j<n;j++)
	 		*(*(b+i)+j)=*(*(b+i)+j)/det;        
	}
	return(b);
}

void adjoint(double** a,double** b,int n)
{
    int sign,i,j;
    double** c = allocate_mat((n-1)*(n-1));
    double x;
    
    for(i=0;i<n;i++)
     	for(j=0;j<n;j++)
      	{
		formdet(a,c,i,j,n);
	  	x=determenant(c,n-1);
	  	if((i+j)%2==0) sign=1; else sign=-1;
		*(*(b+j)+i)=x*sign;
	}
    destroy(c,n-1);
}

void formdet(double** a,double** c,int rw,int cl,int n)
{
    int i,j;
    i=0;
    while(i<n)
    {
       if(i<rw)
       {
	  j=0;
	  while(j<n)
	  {
	     if(j<cl)
	       *(*(c+i)+j)=*(*(a+i)+j);
	     if(j>cl)
	      *(*(c+i)+j-1)=*(*(a+i)+j);
	     j++;
	  }
       }
       if(i>rw)
       {
	  j=0;
	  while(j<n)
	  {
	     if(j<cl)
	      *(*(c+i-1)+j)=*(*(a+i)+j);
	     if(j>cl)
	      *(*(c+i-1)+j-1)=*(*(a+i)+j);
	     j++;
	  }
       }
       i++;
    }
}

/*double determenant(double** a,int n)
{
   	double** c,sum=0,x;
   	int j,sign;
	
  	if(n==1) return(a[0][0]);
   	else
   	{
		c=allocate_mat((n-1)*(n-1));
		for(j=0;j<n;j++)
		{
			formdet(a,c,0,j,n);
			x=determenant(c,n-1);
	       		if(j%2==0) sign=1; else sign=-1;
			sum=sum+sign * x *  (*(*(a)+j));
		}
		destroy(c,n-1);
		return(sum);
   	}
}*/

double determenant(double** arr,int dim)
    {
            //For bigger determinants....
            //Will reduce to the row-echelon form and then take product of diagonals
    
       double prod = 1;
       int sign = 1;
       
       int i;

       //First , create a copy of this matrix
       /*
	* double** arr = new double*[dim];
	* for(i=0;i<dim;i++)
	*      arr[i] = new double[dim];
	*      int j;
	*      for(i=0;i<dim;i++)
	*      	for(j=0;j<dim;j++)
	*      	    arr[i][j] = this->arr[i][j];
	*/




       
       for(i=dim-1;i>=0;i--)
       {
           int whichone = i;
           //Row i will be exchanged with row whichone ..finally...
           
           int j;
           for(j=i;j>=0;j--)
           {
               if(arr[j][i] != 0)
               {
                    whichone = j;
                    break;
                       
               }
           }
           //Now to exchange row whichone with row i
           double* tmp = arr[i];
           arr[i] = arr[whichone];
           arr[whichone] = tmp;
           if(i != whichone)sign *= -1;

           if(arr[i][i]==0)continue;
           
           //Now to make the ith column entry of each row < i = 0;
           for(j=i-1;j>=0;j--)
           {
                double factor = arr[j][i]/arr[i][i];
                int k;
                for(k=0;k<dim;k++)
                    arr[j][k] -= arr[i][k]*factor;
                

           }
                           

           
        //   print();
       }

       //Now the matrix will be in the row echelon-form....
    //   print();
       for(i=0;i<dim;i++)
               prod *= arr[i][i];
       
       /*for(i=0;i<dim;i++)
	*     delete[] arr[i];
	* delete[] arr;
	*/
       
     //  printf("\nreturning %f\n",sign*prod);  
       return sign*prod;       
    }
    



