/**********************************************************************
    Copyright (C) 2004 Database Systems Lab, Supercomputer Education and
    Research Centre, Indian Institute of Science, Bangalore, INDIA.
    http://dsl.serc.iisc.ernet.in

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
***********************************************************************/


/***********************************************************************
 Miscellaneous functions to handle time.
***********************************************************************/
#ifndef OURTIME_H_
#define OURTIME_H_

#include <unistd.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <assert.h>

double diff_time(struct timeval& t1, struct timeval& t2)
{ //return t1 - t2
    double fraction = (t1.tv_usec - t2.tv_usec) / (double) 1000000;

    return ((double)(t1.tv_sec - t2.tv_sec) + fraction);
}

double diff_time(struct rusage& t1, struct rusage& t2)
{ //return t1 - t2; sum of user and system times.
    return (diff_time(t1.ru_utime, t2.ru_utime) +
	    diff_time(t1.ru_stime, t2.ru_stime));
}

void showtime(int arg = 0)
{ //arg = 0 means reset
  //calling showtime(0) will reset the counter. showtime(1) will
  //print the time spent since showtime() was last called.
    static struct rusage r1, r2;
    if (arg == 0)
    {
	getrusage(RUSAGE_SELF, &r1);
	return;
    }

    getrusage(RUSAGE_SELF, &r2);

    cout << diff_time(r2.ru_utime, r1.ru_utime) << "user " <<
	    diff_time(r2.ru_stime, r1.ru_stime) << "system" << endl;

    r1 = r2;
}

#endif
