/**********************************************************************
    Copyright (C) 2004 Database Systems Lab, Supercomputer Education and
    Research Centre, Indian Institute of Science, Bangalore, INDIA.
    http://dsl.serc.iisc.ernet.in

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
***********************************************************************/


#include<math.h>
#include<stdio.h>
#include <new.h>
#include<stdlib.h>
#include<fstream.h>

double n_c_k(int n,int k){
  if (n==0)
    return 1; 
  else if (k > n)
    return 0;
  else if (k > (n/2))
    return n_c_k(n,n-k);
  else{
    double answer=1;
    int j;
    double j1;
    for( j=0;j<k;j++)
      answer = answer*(n-j);
    
    for(j1=1;j1<=k;j1++)
      answer = answer/j1;
    
    return answer;
  }
}
  
  
double mat_entry(int n,int k1,int x,float p){
  
  int lower= (x<0)? -x : 0;
  int upper = (k1 < (n-k1-x))? k1 : (n-k1-x);
  double result =0;
  for(int j=lower;j<=upper;j++)
    result = result + (double)(n_c_k(k1,j)*n_c_k(n-k1,j+x)*(pow(p,(n-2*j-x)))*(pow((1-p),(2*j+x))));
  return result;
}

double mat_entry1(int n,float p,int a1,int a2){
  // this is the entry a2-> a1
  return mat_entry(n,a2,a1-a2,p);
}

// till here all's fine

void swaprows(double **mat,int size,int rowi,int rowj){
  
  double temp;
  for(int j=0;j<size;j++){
    temp = mat[rowi][j];
    mat[rowi][j] = mat[rowj][j];
    mat[rowj][j] = temp;
  }
}

int exchangable(double **mat,int size,int row){
  for(int j=row+1;j<size;j++)
    if(mat[j][row] !=0)
      return j;
  return -1;
}
     


double* weights_gen(int n,float p){
  // to make the n+1 dim matrix first...
  double **mat;
  double **id;
  mat = new double*[n+1];
  id = new double*[n+1];
  int i,j,k;
  for(j=0;j<n+1;j++){
    mat[j]=new double[n+1];
    id[j]=new double[n+1];
  }

  for(i=0;i<n+1;i++)
    for(j=0;j<n+1;j++){
      if (i ==j)
	id[i][j] = 1;
      else
	id[i][j] = 0;
      mat[i][j] = mat_entry1(n,p,i,j);
    }
    
  double ratio;
  int ex;
  // gauss jordan inversion method
  for(i=0;i<n;i++){
    if (mat[i][i] == 0){
      //   cout<<"hi "<<i<<"\n";
      ex = exchangable(mat,n+1,i);
      //  cout<<"hi1 "<<i<<"\n";
      swaprows(mat,n+1,i,ex);
      swaprows(id,n+1,i,ex);
    }
    //cout<<"hi2 "<<i<<"\n";
    for(j=i+1;j<n+1;j++){
      ratio = mat[j][i]/mat[i][i];
      //cout<<"hi3 "<<j<<"\n";
      for(k=0;k<n+1;k++){
	//cout<<"hi4  "<<k<<"\n";
	mat[j][k] = mat[j][k] - ratio*mat[i][k];
	id[j][k] = id[j][k] - ratio*id[i][k];
      }
    }
  }
  
  double factor = mat[n][n];
 
  double* result = new double[n+1];
  for(i=0;i<n+1;i++)
    result[i] = id[n][i]/factor;

  return result;
}


/*
int main(){
  // float prob=atof(argv[1]);
  //int n=atoi(argv[2]);
  int n = 2;
  float p = 0.9;
    
  double* wts = weights_gen(n,p);
    
  for(int i=0;i<3;i++)
    cout<<wts[i]<<" ";
  cout<<"\n";
  
  for(int i=0;i<n+1;i++){
    for(int j=0;j<n+1;j++)
      cout<<mat_entry1(n,p,i,j)<<" ";
    cout<<"\n";
  }
  double sum;
  for(int j=0;j<n+1;j++){
    sum = 0;
    for(int i=0;i<n+1;i++){
      sum = sum + wts[i]*mat_entry1(n,p,i,j); 
    }
    cout<<sum<<"  ";
  }
  return 0;  
}
*/











