/**********************************************************************
    Copyright (C) 2004 Database Systems Lab, Supercomputer Education and
    Research Centre, Indian Institute of Science, Bangalore, INDIA.
    http://dsl.serc.iisc.ernet.in

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
***********************************************************************/


#include<iostream.h>
#include<stdio.h>
#include<unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdlib.h>
#define ONLY_CHECK 0
float p;
float q;
//int seed=1;
#define DEBUG 0

int getTuple(int in_fd,char* tuple,int noAttr)
{
	int tmp;
	int nitems;
	int list[noAttr];
	int readbytes;
	
	//srand(seed);
	
	readbytes=read(in_fd,&tmp,sizeof(int)); ///tno
	if(readbytes<=0)
		return(readbytes);
	
	readbytes+=read(in_fd,&tmp,sizeof(int)); //cno
	readbytes+=read(in_fd,&nitems,sizeof(int)); //nitems
	
	readbytes+=read(in_fd,(char*)list,nitems*sizeof(int)); //items
	
	if(DEBUG)
	{	
		for(int t=0;t<nitems;t++)
			printf("%d ",list[t]);
		printf("\n");
	}

	int prev_item=-1;
	for(int j=0;j<nitems;j++)
	{
		//read(fp,&item,sizeof(item));

		//distort 0s
		int i;
		for(i=prev_item+1;i<list[j];i++)
			{
				//float r=1+(int) (100.0*rand()/(RAND_MAX+1.0));
				float r=1.0*rand()/RAND_MAX;
				if(DEBUG){cout<<r<<" ";}
				if(r<=q)
					tuple[i]='0';
				else 
					tuple[i]='1';
			}
			//distort 1
				//float r=1+(int)(100.0*rand()/(RAND_MAX+1.0));
		float r=(rand()*1.0)/(RAND_MAX);
		if(DEBUG){cout<<r<<" ";}
		if(r<=(p))
			tuple[i]='1';
		else
			tuple[i]='0';
		prev_item=list[j];
	}
	for(int i=prev_item+1;i<noAttr;i++)
	{
		//float r=1+(int) (100.0*rand()/(RAND_MAX+1.0));
		float r=1.0*rand()/RAND_MAX;
		if(DEBUG){cout<<r<<" ";}
		if(r<=(q))
			tuple[i]='0';
		else 
			tuple[i]='1';
	}

	
	
	return(readbytes);
}



main(int argc,char*argv[])
{
if(argc<7)
{
	printf("Usage : ./a.out <no of Attributes> <input binary file> <output binary listfile> <p> <q> <seed>\n");
	exit(0);
}

int in_fd=open(argv[2],O_RDONLY);
int out_fd;
int noAttr = atoi(argv[1]);
cout<<noAttr<<"\n";

char* tuple=new char[noAttr];
//int* list = new int[noAttr+3];
int list[1003];
int noItems=0;

////////////////////
p=atof(argv[4]);
q=atof(argv[5]);
//seed=atoi(argv[6]);
int readbytes = getTuple(in_fd,tuple,noAttr);

//for check
/*printf("%f,%f\n",p,q);
int count1=0;
for(int i=0;i<noAttr;i++)
{
	if(tuple[i]=='1')
		count1++;
	printf("%c",tuple[i]);
}
	printf("count 1 = %d\n",count1);
exit(1);
*/
//////////////////////


int tn=0;

if(ONLY_CHECK == 0)
{
out_fd=open(argv[3],O_CREAT|O_WRONLY|O_TRUNC);

while(readbytes>0)
{
	tn++;
	list[0]=tn;//transaction no
	list[1]=tn;//junk
	
	noItems=0;
	for(int k=0;k<noAttr;k++)
		if(tuple[k]=='1')
		{
			list[noItems+3]=k;
			noItems++;
		}
	list[2]=noItems;
	
	if(DEBUG)
	{
	cout<<"distorted transaction\n";
	for(int k=0;k<noItems+3;k++)
		cout<<list[k]<<" ";
	cout<<"\n";
	getchar();
	}
	
	write(out_fd,(char*)list,(noItems+3)*sizeof(int));

	if(tn%100000==0)
		printf("%d..",tn);fflush(stdout);
	
	///////////////////////
	readbytes = getTuple(in_fd,tuple,noAttr);
	/////////////////////////

	
}
}
close(in_fd);
close(out_fd);



//To check
/*
in_fd=open(argv[3],O_RDONLY);
int x;
readbytes = read(in_fd,&x,sizeof(x));
while(readbytes>0)
{
	read(in_fd,&x,sizeof(x));
	cout<<x<<":";
	read(in_fd,&x,sizeof(x));
	cout<<x<<":";
	read(in_fd,list,sizeof(int)*(x));
	cout<<x<<":";
	for(int k=0;k<x;k++)
		cout<<list[k]<<" ";
	cout<<"\n";
	
	readbytes = read(in_fd,&x,sizeof(x));

}
close(in_fd);
*/
}
