/**********************************************************************
    Copyright (C) 2004 Database Systems Lab, Supercomputer Education and
    Research Centre, Indian Institute of Science, Bangalore, INDIA.
    http://dsl.serc.iisc.ernet.in

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
***********************************************************************/


 #include <time.h>
 #include "matrix.h"

#ifndef _NO_NAMESPACE
using namespace std;
using namespace math;
#define STD std
#else
#define STD
#endif

#ifndef _NO_TEMPLATE
typedef matrix<double> Matrix;
#else
typedef matrix Matrix;
#endif

#ifndef _NO_EXCEPTION
#  define TRYBEGIN()    try {
#  define CATCHERROR()  } catch (const STD::exception& e) { \
                                                cerr << "Error: " << e.what() << endl; }
#else
#  define TRYBEGIN()
#  define CATCHERROR()
#endif
double** Inverse_lib(double** mat_in, int n)
{
	
	double** result;
		
	Matrix m1;
        int i,j;

        for (i=0; i < 4; i++)
        	for (j=0; j < 4; j++)
                	m1(i,j) = mat_in[i][j];
        m1.SetSize(n,n);

	Matrix m2 = !m1;		
	cout<< m2 <<endl;
	
	result=new double*[n];
	for (i=0; i < n; i++)
		result[i]=new double[n];
       	
	for (i=0; i < n; i++)
        	for (j=0; j < n; j++)
       			result[i][j]=m1(i,j);     		
	
	return(result);
}
