/**********************************************************************
    Copyright (C) 2004 Database Systems Lab, Supercomputer Education and
    Research Centre, Indian Institute of Science, Bangalore, INDIA.
    http://dsl.serc.iisc.ernet.in

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
***********************************************************************/


#include <stdio.h>
#include <iostream.h>

double** invert( double** D, int n);
double** allocate_mat(int n)
{
        double** arr = new double*[n];
        for(int i=0;i<n;i++)
                arr[i] = new double[n]; 
        return(arr);
}

void destroy(double** arr, int n)
{
        int i;
        for(i=0;i<n;i++)
                delete[] arr[i];

        delete[] arr;
}

void printmat(double** a,int n)
 {
   int i,j;
   for(i=0;i<n;i++)
   {
         printf("\n");
         for(j=0;j<n;j++)
                 printf("%lf  ",*(*(a+i)+j));
   }
   printf("\n");
 }
 
/*
main()
{
	//double a[10][10];
	int i,j,n;


	
	printf("\n n= ");
  	scanf("%d",&n);

	double **a= new double*[n];
	for(i=0;i<n;i++)
		a[i]=new double[n];
  	
	
	for(i=0;i<n;i++)
        	for(j=0;j<n;j++) 
			scanf("%lf",*(a+i)+j);
  	printf("\n A= ");
  	printmat(a,n);
  	//printf("det of A = %7.4f",determenant(a,n));

  	a=invert(a,n);
  	printf("\n A inverse =");
  	printmat(a,n);

}
*/

/* invert the D matrix */
double** my_invert( double** D, int n)
{
double alpha;
double beta;
int i;
int j;
int k;
int error;

	error = 0;
	int n2 = 2*n;


double **newD = new double*[n];
for(i=0;i<n;i++)
	newD[i]=new double[n2];

for(i=0;i<n;i++)
	for( j = 0; j < n; j++ )
		*(newD[i]+j)=*(D[i]+j);

/* init the reduction matrix  */
	for( i = 0; i < n; i++ )
	{
		for( j = 0; j < n; j++ )
		{
			*(newD[i]+j+n) = 0.0;
		}
		*(newD[i]+i+n) = 1.0;
	}

/* perform the reductions  */
	for( i = 0; i < n; i++ )
	{
		alpha = *(newD[i]+i);
		if( alpha == 0.0 ) /* error - singular matrix */
		{
			error = 1;
			break;
		}
		else
		{
			for( j = 0; j < n2; j++ )
			{
				*(newD[i]+j) = *(newD[i]+j)/alpha;
			}
			for( k = 0; k < n; k++ )
			{
				if( (k-i) != 0 )
				{
					beta = *(newD[k]+i);
					for( j = 0; j < n2; j++ )
					{
						*(newD[k]+j) = *(newD[k]+j) - beta * (*(newD[i]+j));
					}
				}
			}
		}
	}

	double** ResD = allocate_mat(n);
	for(i=0;i<n;i++)
		for( j = 0; j < n; j++ )
			*(ResD[i]+j)=*(newD[i]+j+n);

	for(i=0;i<n;i++)
		delete newD[i];
	delete newD;
	
	return ResD;
}


