#ifndef _CONSTRUCT_H_
#define _CONSTRUCT_H_

/***********************************************************************
 AUTHOR: Srikanta Bedathur
 DESCRIPTION:

    Copyright (C) 2004 Database Systems Lab, Supercomputer Education and
    Research Centre, Indian Institute of Science, Bangalore, INDIA.
                     http://dsl.serc.iisc.ernet.in

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
***********************************************************************/
#include "allocator.h"
#include "smartref.h"
#include "sfxnode.h"
#include "s_man.h"

Ref *root;

StorageManager<SfxNode, true> *leaf_sm;
StorageManager<SfxInternalNode, false> *internal_sm;

Allocator <SfxNode,true>  *leaf_alloc;
Allocator <SfxInternalNode,false> *internal_alloc;

void constructSuffixTree (Allocator<SfxNode, true>* leaf_alloc, 
			  Allocator<SfxInternalNode, false> *internal_alloc,
			  Ref& root, char* sequence, long M);

#endif 
