#ifndef _KEY_H_
#define _KEY_H_

/***********************************************************************
 AUTHOR: Srikanta Bedathur
 DESCRIPTION:
    Packing the information into a Key integer.

    Copyright (C) 2004 Database Systems Lab, Supercomputer Education and
    Research Centre, Indian Institute of Science, Bangalore, INDIA.
                     http://dsl.serc.iisc.ernet.in

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
***********************************************************************/
///////////////////////////////////////////////
/// Contains code to form keys (in the form of 
/// unsigned longs) and to extract individual 
/// components from it
/// 
/// Used in s_man.h
///////////////////////////////////////////////

#ifdef SMALL_PAGE

#define KEY(key,fileid,pageid)\
ASSERT(fileid < 4);\
ASSERT(pageid < (1<<27));\
key=fileid; key <<= 27;\
key |= (0x0effffff & pageid);

#define FILEID(key)\
((key >> 27)& 0x03)

#define PAGEID(key)\
(key & 0x0effffff)

#else /**** NORMAL PAGE SIZE *****/

#define KEY(key,fileid,pageid)\
ASSERT(fileid < 4);\
ASSERT(pageid < (1<<19));\
key=fileid; key <<= 19;\
key |= (0x0007ffff & pageid); \
assert(key != 0);

#define FILEID(key)\
((key >> 19)& 0x03)

#define PAGEID(key)\
(key & 0x07ffff)

#endif /*SMALL_PAGE*/



#endif
