#ifndef _OPTIONS_H_
#define _OPTIONS_H_

/***********************************************************************
 AUTHOR: Srikanta Bedathur
 DESCRIPTION:
    Options processing for the whole program.

    Copyright (C) 2004 Database Systems Lab, Supercomputer Education and
    Research Centre, Indian Institute of Science, Bangalore, INDIA.
                     http://dsl.serc.iisc.ernet.in

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
***********************************************************************/
#include <string>
#include <iostream>
#include <fstream>


using namespace std;

enum keytype {STRING, INT};
enum stagetype {S, C, SC};

struct metakeys {
  string word;
  enum keytype ktype;
  enum stagetype stype;
};

////////////////////////////////////////////////////////////////
/// All the common things needed during the suffix tree
/// construction and search are abstracted into this class.
/// . data file name
/// . data size
/// . index basedir (note that internal and leaf indexes are 
///                  are stored under this directory, within
///                  internal/ and leaf/ subdirectories)
/// . number of files or extents for both internal and leaf
/// . size of the last page for both leaf and internal (in terms
///                  of number of bytes written finally)
/// . internal Node size and leaf node size (for ensuring that
///                  the base assumptions such as alphabetsize
///                  size of the nodes etc. are same)
/// . trace file names, internal and leaf, if needed.
////////////////////////////////////////////////////////////////

class Options {
private:
  static string _optionsFilename;

public:
  /* 1. Data */
  static string datafile;
  static long datasize;
  
  /* 2. Index */
  static string leafBasefile;
  static string internalBasefile;

  /* 3. Verification */
  static int internalNodeSize;
  static int leafNodeSize;

  /* 4. Data in memory - not to be written */
  static char* sequence;

public:
  //  Options();
  
  static void read (string optionsFileName);

  
  //  void write ();

  static const string getLeafBasefile ();
  static const string getInternalBasefile ();
};

#endif
