#ifndef _PAGE_H_
#define _PAGE_H_

/***********************************************************************
 AUTHOR: Srikanta Bedathur
 DESCRIPTION:
    Page structure used throughout.

    Copyright (C) 2004 Database Systems Lab, Supercomputer Education and
    Research Centre, Indian Institute of Science, Bangalore, INDIA.
                     http://dsl.serc.iisc.ernet.in

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
***********************************************************************/
#include "defines.h"


/********************************************************
 * The page contains the following information
 * . average depth of the page
 * . number of objects
 * . data space itself
 ********************************************************/
#define DATASIZE (DISKPAGESIZE - sizeof(double))
struct page_t {

public:
  double _avgdepth;
  uchar _page [DATASIZE];


public:
  page_t () {
    _avgdepth = 0.0;
    //    _count = 0;
    memset (_page,0,DATASIZE); 
  }

  /////////////////////
  // Copy constructor
  /////////////////////
  page_t (page_t& other) {
    ASSERT (other.data());
    memcpy(_page, other.data(), DATASIZE);
    _avgdepth = other.avgdepth();
    //    _count = other.getcount();
  }

  //////////////////////
  // Assignment operator
  //////////////////////
  page_t& operator=(page_t& rhs) {
    ASSERT (rhs.data());
    memcpy(_page, rhs.data(), DATASIZE);
    _avgdepth = rhs.avgdepth();
    //    _count = rhs.getcount();   
    return (*this);
  }

  ~page_t () {
  }

  SFXULONG datasize () {
    return DATASIZE;
  }


  uchar* data() {
    return &(_page[0]);
  }

  void avgdepth(double _avgdpt) {
    _avgdepth = _avgdpt;
  }

  double avgdepth () {
    return _avgdepth;
  }


  /////////////////////////////////
  // increment the count
  // called from allocator
  ////////////////////////////////
  void count() {
    //    _count++;
  }


  ushort getcount () {
    //    return _count;
    return 0;
  }
  
  ////////////////////////////////
  /// This is the method to return
  /// the whole page to be written
  /// used in Storage object.
  ////////////////////////////////
  uchar* page() {
    return (uchar*)this;
  }

};

#endif
