#ifndef _SEQITER_H_
#define _SEQITER_H_

/***********************************************************************
 AUTHOR: Srikanta Bedathur
 DESCRIPTION:
    Iterator class for FASTA-like DNA sequence files.

    Copyright (C) 2004 Database Systems Lab, Supercomputer Education and
    Research Centre, Indian Institute of Science, Bangalore, INDIA.
                     http://dsl.serc.iisc.ernet.in

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
***********************************************************************/
#include <fstream>
#include <string>
#include <utility>

using namespace std;
#define ERRLOG(log_mess) \
	cerr << log_mess << endl

#define DEBUGLOG(dbg_mess) \
	cout << dbg_mess << endl

class SeqFileIterator{
public:
  static const int seqEOF = 0x01;
  static const int seqITER = 0x02;
  static const int seqREADY = 0x04;
  static const int seqFAIL = 0x08;
  static const int seqCLOSE = 0x0A;
  
private:
  static const int STRLENGTH = 4096;

  char _seqFileName[256];
  ifstream _seqInputStream;

  string _seqBuffer;

  string _metaline;


  int _status;
  
#ifdef CLEANUP
  string cleanup(char* cur_str);
#endif

public:
  SeqFileIterator( const char *seqFileName );
  SeqFileIterator( );
  ~SeqFileIterator ();
  void  attach( const char *seqFileName );

  pair<string,string> next();
  void  init();
  bool  eof();	
  bool fail();
  
  int size();
  void close();
};

#endif /* _SEQITER_H_*/
