#ifndef _STORAGE_H_
#define _STORAGE_H_

/***********************************************************************
 AUTHOR: Srikanta Bedathur
 DESCRIPTION:
    Storage Interface - an abstract class.

    Copyright (C) 2004 Database Systems Lab, Supercomputer Education and
    Research Centre, Indian Institute of Science, Bangalore, INDIA.
                     http://dsl.serc.iisc.ernet.in

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
***********************************************************************/
#include "defines.h"
#include "page.h"

class Storage {
protected:
  bool isleaf;
  enum PHASE phase;
public:
  Storage (bool _isleaf, enum PHASE _phase = CONSTRUCT):isleaf(_isleaf),phase(_phase) {
  }

  virtual int s_open (SFXULONG fileid) = 0;
  virtual int s_pwrite (SFXULONG fileid, SFXULONG pageid, page_t* page_ptr) = 0;
  virtual int s_pread (SFXULONG fileid, SFXULONG pageid, page_t* page_ptr) = 0;
};
#endif
