/***********************************************************************
 AUTHOR: Srikanta Bedathur
 DESCRIPTION:
    Globally needed definitions and statistics implementation.

    Copyright (C) 2004 Database Systems Lab, Supercomputer Education and
    Research Centre, Indian Institute of Science, Bangalore, INDIA.
                     http://dsl.serc.iisc.ernet.in

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
***********************************************************************/
#include <assert.h>
#include "defines.h"
#include "timings.h"

#include <sys/time.h>
#include <unistd.h>
using namespace std;
PRECURSOR

string sfxfilesuffix [4] = {".0",
			    ".1",
			    ".2",
			    ".3"};

#ifdef FILESTATS
SFXULONG read_internal_count = 0;
SFXULONG write_internal_count = 0;
SFXULONG unpin_internal_count = 0;

SFXULONG read_leaf_count = 0;
SFXULONG write_leaf_count = 0;
SFXULONG unpin_leaf_count = 0;
#endif

#ifdef SMSTATS
SFXULONG buffer_internal_hits = 0;
SFXULONG buffer_internal_requests = 0;
SFXULONG buffer_leaf_hits = 0;
SFXULONG buffer_leaf_requests = 0;
#endif


#ifdef STATS
SFXULONG suffixlinks = 0;
SFXULONG edgestaken = 0;
SFXULONG skipcountpasses = 0;
SFXULONG suffixlinkstaken = 0;
SFXULONG jumplength = 0;
#endif


void err_msg (char* msg, int level) {
  if (msg)
    cerr << msg << endl;

  switch(level){
  case DISASTER: assert(false);break;
  }
}

void initstats () {
  PRELUDE;
  gettimeofday(pt_begin, tz);
#ifndef GEN_TRACE
#if defined(FILESTATS)||defined(STATS)||defined(SMSTATS)
  cout << "#I \t"
#ifdef FILESTATS
       << "IN-READS \t"
       << "LF-READS \t"
       << "IN-WRITE \t"
       << "LF-WRITE \t"
       << "IN-UNPIN \t"
       << "LF-UNPIN \t"
#endif
#ifdef STATS
       << "LNK-FRMD \t"
       << "EDG-TKN  \t"
       << "SKP-CNT  \t"
    //       << "AVG-EDG  \t"
#endif
#ifdef SMSTATS
       << "IN-HITS  \t"
       << "IN-REQST \t"
    //       << "IN-BFHTR \t"
       << "LF-HITS  \t"
       << "LF-REQST \t"
    //       << "LF-BFHTR   "
#endif
       << endl;
#endif
#endif
}
void printstats (SFXULONG i) {
  gettimeofday(pt_end, tz); 
  if (i != 0) {
#if defined(FILESTATS)||defined(STATS)||defined(SMSTATS)
    cerr << i << "   " << pt_end->tv_sec - pt_begin->tv_sec << endl;
#endif
  }
  else{
    cerr << "# Time to build: sec = "
	 << pt_end->tv_sec - pt_begin->tv_sec << " usec = "
	 << pt_end->tv_usec - pt_begin->tv_usec
	 << endl;
	delete (pt_begin);
	pt_begin = pt_end;
	pt_end = new struct timeval;
  }
  if (i != 0) {
#if defined(FILESTATS)||defined(STATS)||defined(SMSTATS)
    cout << i << "\t"
#ifdef FILESTATS
         << read_internal_count << " \t"
         << read_leaf_count << " \t"
         << write_internal_count << " \t"
         << write_leaf_count << " \t"
         << unpin_internal_count << " \t"
         << unpin_leaf_count << "\t"

#endif
#ifdef STATS
	 << suffixlinks << "\t" 
	 << edgestaken << "\t" 
	 << skipcountpasses << "\t" 
      //	 << (double)edgestaken / (double)skipcountpasses << "\t"
#endif
#ifdef SMSTATS
	 << buffer_internal_hits << "\t"
	 << buffer_internal_requests << "\t"
      //	 << (double)buffer_internal_hits / (double)buffer_internal_requests << "\t"
	 << buffer_leaf_hits << "\t" 
	 << buffer_leaf_requests << "\t"
      //	 << (double)buffer_leaf_hits / (double)buffer_leaf_requests
#endif
	 << endl;
#ifdef INCREMENTAL_SMSTATS
    buffer_internal_hits = buffer_internal_requests = 0;
    buffer_leaf_hits = buffer_leaf_requests = 0;
#endif /*INCREMENTAL_SMSTATS*/
#else
//	cerr << "." ;
#endif
	
#ifdef GEN_TRACE
//    cout << endl; //This will dilineate a block of characters used.
#endif
  }
}
