/***********************************************************************
 AUTHOR: Srikanta Bedathur
 DESCRIPTION:
    Simple exact matching algorithm over an already constructed 
    suffix tree.

    Copyright (C) 2004 Database Systems Lab, Supercomputer Education and
    Research Centre, Indian Institute of Science, Bangalore, INDIA.
                     http://dsl.serc.iisc.ernet.in

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
***********************************************************************/
#include "smartref.h"
#include "sfxnode.h"
#include "s_man.h"
#include "defines.h"
#include "search.h"

#include <string>

using namespace std;

#ifdef LINKEDLIST
void DFS (Ref begin) {
  if ((SFXULONG)begin == 0) return;
  if (!begin.isleaf() && !begin->getNextParentFlag()) {
    Ref child = (*begin)->getChild();
    for (; !child -> getNextParentFlag ();
	 child = child -> getNext()) {
      if ((SFXULONG)child != 0) {
	DFS (child);
      }
    }
  }
  else {
    cerr << "Pos: " << begin -> getbegin() << endl;
  }
}
#else
void DFS (Ref begin)  {
  if ((ulong)begin == 0) return;
  if (!begin.isleaf()) {
    for (int i=0;i < ALPHABETSIZE ;i++) {
      Ref child = (*begin)->locateChildIdx (i);
      if ((ulong)child != 0) {
	DFS (child);
      }
    }
  }
  else {
    cerr << "Pos: " << begin->getbegin() << endl;
  }
}
#endif 

void readRoot (Ref& root) {
  SFXULONG rootval;
  //
  // Root is the recid = 1, blockid = 0, fileid = 0 of
  // isleaf = 0 
  // So, set the reference value to that
#ifndef SMALL_PAGE
  rootval = 0x01 << 10; //just set the 11-th bit
#else
  rootval = 0x01 << 2; // set the 3rd bit
#endif
  root = rootval;
}

int searchSuffixTree (StorageManager <SfxNode, true>* leaf_sm,
		      StorageManager <SfxInternalNode, false> *internal_sm,
		      Ref& root,
		      const char *sequence,
		      const char *query,
		      long sequencelength,
		      long querylength) {
  

  Ref curnode (0);
  Ref child (0);


  readRoot(root);

  long i, j;
  long h = 0;

  if (querylength > sequencelength) {
    return -1;
  }

  curnode = root;

  long queryrem = querylength;
  long edgelen = 0;
  const char *edgestr;
  

  // Process the whole length of the querysequence
  for (i = 0; i < querylength;) {
    
    // Locate the child starting with the next 
    // character in the query

    Ref temp = (*curnode)->locateChild (query[i]);
    
    if ( (ulong) temp == 0) {
      // There is no child
      // since query string is not finished yet,
      // this clearly means that the query
      // does not exist in the sequence

      return -1;
    }

    edgelen = temp -> getlength();
    edgestr = sequence + temp -> getbegin();
    
    j = 0;
    
    while ( j < edgelen && i < querylength) {
      if (tolower(edgestr [j]) != tolower(query [i])) {
	// There is a mismatch in the sequences
	// So the search fails
	return -1;
      }
      i++;
      j++;
    }

    if (i == querylength) {
      // The query sequence is finished
      // and therefore the search is successful
      
      //XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      // We need to do a DFS from this node 'temp' downwards, 
      // till ALL leaves under it are returned.
      //XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      
      DFS (temp);
      
      return 1;
    }
    else {
      assert (j >= edgelen);
      if (temp.isleaf()) {
	//
	// if the currently processed node is 
	// a leaf node, and the query has not
	// finished - then again the query
	// sequence doesn't exist completely
	//
	return -1;
      }
      else {
	curnode = temp;
      }
    }
  }


}
