/***********************************************************************
 AUTHOR: Srikanta Bedathur
 DESCRIPTION:
    Internal node implementation for array representation of nodes.

    Copyright (C) 2004 Database Systems Lab, Supercomputer Education and
    Research Centre, Indian Institute of Science, Bangalore, INDIA.
                     http://dsl.serc.iisc.ernet.in

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
***********************************************************************/
#ifndef LINKEDLIST

#include <iostream>
#include <assert.h>
#include "defines.h"
#include "sfxnode.h"

SfxInternalNode::SfxInternalNode ():SfxNode(){
  for (int i = 0; i < ALPHABETSIZE; i++) {
    child[i] = 0;
  }
  suffixLink = 0;
}

void SfxInternalNode::addChild (SFXULONG _cpointer, unsigned char c){
  ASSERT (_cpointer != 0);
  ASSERT (ALPHABETINDEX(c) < ALPHABETSIZE);
  ASSERT (child[ALPHABETINDEX(c)] == 0);

  child[ALPHABETINDEX(c)] = _cpointer;
}

SFXULONG SfxInternalNode::removeChild(unsigned char _c){
  SFXULONG retval;
  retval = child[ALPHABETINDEX(_c)];
  child[ALPHABETINDEX(_c)] = 0;
  
  return retval;
}

SFXULONG SfxInternalNode::locateChild(unsigned char _c)const{
  DBG_TRACE ("SfxInternalNode::locateChild (" << _c << ")" << endl);
  if (ALPHABETINDEX(_c) >= ALPHABETSIZE)
    return 0;
  return child[ALPHABETINDEX(_c)];
}

SFXULONG SfxInternalNode::locateChildIdx (unsigned char idx) const {
  DBG_TRACE("SfxInternalNode::locateChildIdx (" << idx << ")" << endl);
  if (idx >= ALPHABETSIZE)
    return 0;
  return child[idx];
}

void SfxInternalNode::setSuffixLink (SFXULONG _sfx){
  ASSERT (suffixLink == 0);
  suffixLink = _sfx;
}

SFXULONG SfxInternalNode::getSuffixLink () const{
  return suffixLink;
}

void SfxInternalNode::print (const char* sequence, const int level) const {

#if 1
  SfxNode::print (sequence, level, false);
  //  cout << " -> " << getSuffixLink ();
#else
  int j;
  OFFSET(level-1);
  for (j = 0; j < 25 && j < length; j++)
    cout << sequence [begins+j];
//   if (j < length)
//     cout << "...[" << length << "]";
#endif
  cout << endl;
}
#endif
