/***********************************************************************
 AUTHOR: Srikanta Bedathur
 DESCRIPTION:
    Node implementation for array-based node representation.

    Copyright (C) 2004 Database Systems Lab, Supercomputer Education and
    Research Centre, Indian Institute of Science, Bangalore, INDIA.
                     http://dsl.serc.iisc.ernet.in

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
***********************************************************************/
#ifndef LINKEDLIST
/*
 * This whole definition of SfxNode class is applicable only
 * when we are dealing with array implementation of the 
 * Suffix-tree nodes
 */
#include <iostream>
#include <string.h>
#include <assert.h>
#include "defines.h"
#include "sfxnode.h"

////////////////////////////////////////////////////////////
/// Leaf Node methods
////////////////////////////////////////////////////////////
SfxNode::SfxNode(){
  ch = 0; 
  begins = length = 0;
  parent = 0;
}

void SfxNode::setch (unsigned char c) {
  /*
  switch(c){
  case 'a': ch = 1; break;
  case 'A': ch = 2; break;
  case 'c': ch = 3; break;
  case 'C': ch = 4; break;
  case 'g': ch = 5; break;
  case 'G': ch = 6; break;
  case 't': ch = 7; break; 
  case 'T': ch = 8; break;
  default : err_msg ("Bad Character !", DISASTER);
  }
  */
  ch = c;
}

unsigned char SfxNode::getch () const {
  /*
  switch(ch){
  case 1: return 'a';
  case 2: return 'A';
  case 3: return 'c';
  case 4: return 'C';
  case 5: return 'g';
  case 6: return 'G';
  case 7: return 't';
  case 8: return 'T';
  default: cerr << "ch: " << ch << endl; err_msg ("How did you get this char?", DISASTER);
  }
  */
  return ch;
}

void SfxNode::setlength (SFXULONG _length){
  ASSERT (_length > 0);
  length = _length;
}

SFXULONG SfxNode::getlength () const {
  ASSERT (length > 0);
  return length;
}

void SfxNode::setbegin (SFXULONG _begins){
  begins = _begins;
}

SFXULONG SfxNode::getbegin () const {
 return begins;
}

void SfxNode::setParent (const SFXULONG  _parent) {
  ASSERT (parent == 0 || _parent == 0);
  parent = _parent;
}

SFXULONG SfxNode::getParent() const {
  ASSERT (parent != 0);
  return parent;
}

void SfxNode::print (const char* sequence, const int level, bool printnl) const {
  OFFSET(level-1);
#if 0
  cout << "char: " << getch()
       << " begin: " << getbegin()
       << " length: " << getlength();
#else
  int j;
  for (j = 0; j < 25 && j < length; j++)
    cout << sequence [begins+j];
  if (j < length)
    cout << "...";
#endif
  if (printnl)
    cout << endl;
}
#endif /*!LINKEDLIST*/
