/***********************************************************************
 AUTHOR: Srikanta Bedathur
 DESCRIPTION:
    Node implementation for linked-list representation of nodes.

    Copyright (C) 2004 Database Systems Lab, Supercomputer Education and
    Research Centre, Indian Institute of Science, Bangalore, INDIA.
                       http://dsl.serc.iisc.ernet.in

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
***********************************************************************/

#ifdef LINKEDLIST

#include <iostream>
#include <string.h>
#include <assert.h>
#include "defines.h"
#include "sfxnode.h"
#include "smartref.h"
////////////////////////////////////////////////////////////
/// Leaf Node methods
////////////////////////////////////////////////////////////
SfxNode::SfxNode(){
  ch = 0; 
  nextparentflag = 0;
  begins = length = 0;
  next = 0;
}

void SfxNode::setch (unsigned char c) {
  ch = c;
}

unsigned char SfxNode::getch () const {
  return ch;
}

void SfxNode::setNextParentFlag (bool flag) {
  if (flag)
    nextparentflag = 1;
  else
    nextparentflag = 0;
}

bool SfxNode::getNextParentFlag () const {
  if (nextparentflag == 1)
    return true;
  else
    return false;
}

void SfxNode::setlength (SFXULONG _length){
  ASSERT (_length > 0);
  length = _length;
}

SFXULONG SfxNode::getlength () const {
  ASSERT (length > 0);
  return length;
}

void SfxNode::setbegin (SFXULONG _begins){
  begins = _begins;
}

SFXULONG SfxNode::getbegin () const {
 return begins;
}

SFXULONG SfxNode::getParent() const {
  if (nextparentflag == 1)
    return next;
  else {
    Ref _next = next;
    return (_next->getParent());
  }
}

SFXULONG SfxNode::getNext () const {
  return next;
}

void SfxNode::setNext (SFXULONG _next) {
  next = _next;
}

void SfxNode::print (const char* sequence, const int level, bool printnl) const {
  OFFSET(level-1);
#if 0
  cout << "char: " << getch()
       << " begin: " << getbegin()
       << " length: " << getlength();
#else
  int j;
  for (j = 0; j < 25 && j < length; j++)
    cout << sequence [begins+j];
  if (j < length)
    cout << "...";
#endif
  if (printnl)
    cout << endl;
}
#endif
