// File:  largeset.h 
// Created by: Pradeep Shenoy(purdy@cse.iitb.ernet.in)
// Last modified: 10 Aug 1999
//
// Description: 
//     A data structure (the class description) that contains the large 
// itemsets and their counts. Coded as a hashtable with a simple hash 
// function on the itemsets. Also see itemset.h

#ifndef _largeset_h
#define _largeset_h

#include "itemset.h"

class LargeSet_t {

    static const int HTSIZE = 10967;   // Random choice.

    struct LSBuc_t {		// Basic structure for data.
	ItemSet_t *itset;
	int count;
	LSBuc_t *next;
    } *table[HTSIZE];
    
    int HashValue(ItemSet_t *itset);
public:
    LargeSet_t(){
        for (int i = 0; i < HTSIZE; i++) table[i] = NULL;
    }
    ~LargeSet_t(void);

    void Insert(int *i, int len, int count){
	ItemSet_t *itset = new ItemSet_t(i, len);
	Insert(itset, count);
    }

    void Insert(ItemSet_t *itset, int count);
    int GetCount(ItemSet_t *itset); // return count of large itemset

    // Apply passed function on each itemset in LargeSet_t
    void ForAllItemsets(int (*func)(ItemSet_t *));
    void PrintItemsets(ostream& fp); //###### added by vikram
};

#endif // #ifndef _largeset_h

