// File:  snakes.h 
// Created by: Pradeep Shenoy (purdy@cse.iitb.ernet.in)
// Last modified: 20 Aug 1999
//
// Description: 
//  	Contains the class description of code for reading/writing the 
// snakes (= compressed bit-vectors).  Each itemset's snake is given a
// pseudo-id, assigned and kept track of by the computation flow. This
// pseudo-id is used for locating the initial block of the bit-vector.
// 	Storage details: Writing -- maintain a buffer for each snake
// and write it to the end of a common file as and when the buffer is full.
// The buffers for a snake are chained together -- each buffer has its last
// four bytes as the offset of its next buffer. (This means that when a
// buffer is being filled, 
//     (a) The position it will be written to is already fixed  
//     (b) while writing the buffer, we reserve a position in the disk
// for the _next_ buffer of this snake.

#ifndef _snakes_h
#define _snakes_h

#pragma interface

#include <stdlib.h>
#include <unistd.h>
#include "global.h"

// Is actually read in from init.dat at startup time.
#define SN_BUFSIZ (Global::getSnakeBufSize())

extern long du_count;
class RSN {

	unsigned char *data_buf;	// Compressed data
	int readfd;     		// file descriptor

	int nextbuf_offset; // Pointer to position of nextbuf in common file.

	// Internal variables -- used in compression routine.
	int pos, offset;
	int curr_lim;
	int readbit_done, getnext_done, TID;

	inline int readbuf();
	inline int readbit();

	// debug
	int initoffs;

public:
	RSN(){}
	~RSN(){
	    // May want to change this if buffering i/o
	    delete[] data_buf;
	}
	void init_read(int fd, int Offs);
	inline int getNextTid();
	inline int lastTid(){ return TID;}
};

class WSN {

	unsigned char *data_buf; // Compressed data
	int writefd;
	int writeOffs;		 // Where the current buffer will be written.

        // Helps maintain indexing of bufs in common file
	int *global_buffer_count;

	// Internal variables
	int pos, offset;
	int lastTID;
	int saveLastBlock;

	inline void writebit(int);
	inline void writebuf(int);


	// debug;
	int initoffs;
public:
	WSN(){ saveLastBlock = 1;}
	~WSN();
	void init_write(int fd, int initOffs, int *glob_bc);
	inline int addToSnake(int TID);
	void DiscardLastBuffer(void){saveLastBlock = 0;}
};


#endif // #ifndef _snakes_h

