// File:  cand.h 
// Created by: Pradeep Shenoy (purdy@cse.iitb.ernet.in)
// Last modified: 18 August 1999
//
// Description: 
// 	Hash tree + some add-ons for the candidate generation procedure. 
// The candidates are stored as follows: the prefix (all but the last item)
// of the itemset is used for hashing into the hash table. A bucket is
// created for it (shared across all itemsets with the same prefix). This
// bucket also contains a linked lists of all extensions to this prefix --
// i.e., all the last-items of the itemsets with this prefix. These are in
// sorted order. 
// 

#ifndef _cand_h
#define  _cand_h

#pragma interface

#include <iostream.h>
#include <stdlib.h>
#include "global.h"

#define MAXBUC	10389

// First some structs that are used  in the candidate generation.
// The class description follows.

struct Extension_t;

struct Cand {

    int *set;
    Extension_t **to_decrement;	// Which subset-counters to decrement if this
    			// candidate is covered.
    Cand *next;
    int genID1, genID2;

};

struct Extension_t {  	// The struct containing extensions to a prefix
	int member;
	int i, j; // If any...
	int genID;
	int *prefix;
	int frequency;
	Extension_t *next;
};

struct Prefix_t {	// the hash table bucket.
	int *set ;
	int numExt ;
	Extension_t *extlist;
	Prefix_t *next ;
	int conv_flag;
};

struct RestList {	// Used in intermediate computations.
    int member;
    Extension_t **subsets;
    int subsetcount;
    RestList *next;
};


class CandPrune_t {

    Prefix_t **table;
    Cand *candlist;     // List of generated candidates.
    int n_uncovered;	// Number of candidates still to be covered.
    int length;	 	// length of PREFIX.
    int isPrunedGen;    // Whether to prune the covering itemsets.
    
    int n_generators;   // Input number of itemsets
    int numPrunedGens;  // Pruned subset (if pruning on)

    // If pruning -- to store the itemsets required to generate the
    // candidates.
    Extension_t *generatorList;


    //internal variable.
    int *ExtendPrefix;

    // A trivial implementation. Look for superior hashes later.
    int hashvalue(int *set, int ignore = -1);
    int isEqual(int *set1, int *set2, int ignore =-1);

    // Subfunc of insert
    int addSet(int *itemset, int i, int j, Prefix_t *pref, int freq=0); 

    // Subfunctions of getCands()
    int process_prefix(Prefix_t *);
    int ClusterGen(int *, int, RestList *);
    int addCandToList(int *, Extension_t **);
    RestList * CandPrune_t::copy_list(struct Extension_t *, int, Extension_t *);

public:
    CandPrune_t(int length_of_cand, int isPruning);
   ~CandPrune_t();

    // Insert ignores calls with already-present itemsets.
    int insert(int *itemset, int i, int j, int freq=0);
    int insertLargeList(Cand_t *array, int numelems);
    Prefix_t *lookup(int *set, int ignore_elem=-1);

    // Generate a list of candidates. Do alongside some preprocessing 
    // used in generating min-cover
    // Output is an allocated array of candidates. 
    Cand_t *getCands(int *); // store #cands in passed ptr

    // Output list of pruned generators required to cover i+1 candidates. 
    int PruneGenerators(void);
    Cand_t *getPrunedGens(int *); // store #gens in passed ptr.
	
   int getn_uncovered(void){ return n_uncovered ; }
   int getn_generators(void){ return n_generators;}
};

#endif      //#ifndef _cand_h

