// File:  itemset.h 
// Created by: Pradeep Shenoy(purdy@cse.iitb.ernet.in)
// Last modified: 10 Aug 1999
//
// Description: 
//    Contains class description for storing an itemset. Not used in the
// large-itemset counting phase (too expensive, functionality not needed)
// Can be used however. Is instead currently used in the post-counting pass
// for rule generation and pruning.

#ifndef _itemset_h
#define _itemset_h
#include <iostream.h>
#include <assert.h>
enum {
   EQUAL, SUBSET, SUPERSET, NONESET
};

class ItemSet_t {
    int *itemset;
    int length;

public:
    ItemSet_t()
    	:itemset(NULL), length(0)
    {}
    // Conversion.
    ItemSet_t(int*it_a, int len_a){
    	assert(len_a > 0);

	length = len_a;
	itemset = new int[length];
	for (int i = 0; i < length; i++)
	    itemset[i] = it_a[i];
    }

    // Copy constructor.
    ItemSet_t(ItemSet_t* itset){
    	if (itset -> length == 0){
	    itemset = NULL; length = 0; return;
	}
	itemset = new int[itset -> length];
	length = itset -> length;
	for (int i = 0; i < length; i++)
		itemset[i] = itset -> itemset[i];
    }

    ~ItemSet_t(void){ delete itemset; }

    // Shady operator[] ! NOTE THAT IT RETURNS RVALUE, not lvalue.
    // So can't be used as it[x] = val;
    int operator[](int indx){

	if (length == 0 || indx >= length) return -1;
	return itemset[indx];
    }
    int Length(){ return length;}

    // Clumsy way of doing this, currently, but efficiency not crucial
    // here.
    void AddItem(int item){

	int *it = new int[++length];
	for (int i = 0; i < length-1;i++)
	    it[i] = itemset[i];
	it[length-1] = item;

	delete itemset;
	itemset = it;

	return;
    }

    int IsEqual(ItemSet_t *itset){
	if (length != itset -> length) return 0;

	for (int i = 0 ; i < length ; i++)
	    if (itemset[i] != (*itset)[i]) return 0;

        return 1;
    }

    int CompareItemset(ItemSet_t *itset){
	int len1 = length, len2 = itset -> length;
	int *its1 = itemset, *its2 = itset -> itemset;
	int less = 0, greater = 0;

	int i1 = 0, i2 = 0;
	// Assume itemsets are always increasing-sorted.
	while ( i1 < len1 && i2 < len2){
	    if (less && greater) return NONESET;

	    if (its1[i1]  == its2[i2]){
		i1++; i2++;
	    } else if (its1[i1] < its2[i2]){
		i1++;   greater = 1;   // its1 is NotContained	
	    } else {
		i2++; less = 1;        // its2 is NotContained
	    }
	}

	if (less && greater) return NONESET; // required?

	// Atleast one of the flags is off.
	// Now check if the _wrong_ index overflowed.
	if ( (greater && i2 < len2) || (less && i1 < len1))
	    return NONESET;

	// No wrong-index-overflow. Which means flag is correct.
	if (less) return SUBSET;
	if (greater) return SUPERSET;

	// No flags set at all. Only 3 cases possible now.
	if (len1 < len2) return SUBSET;
	if (len1 > len2) return SUPERSET;
	return EQUAL;
    }

    // Create a new itemset unioning $this$ and passed arg.
    ItemSet_t *Union (ItemSet_t *itset){
	int unItset[length +itset -> length];

	int len1 = length, len2 = itset -> length;
	int unLen = 0, i1 = 0, i2 = 0;
	while (i1 < len1 && i2 < len2){
	    if (itemset[i1] == itset -> itemset[i2]){
		unItset[unLen++] = itemset[i1];
		i1++; i2++;
	    } else if (itemset[i1] < itset -> itemset[i2])
		unItset[unLen++] =  itemset[i1++];
	    else unItset[unLen++] = itset -> itemset[i2++];
	}
	
	int *newItset = new int[unLen];
	for (int i = 0; i < unLen; i++) newItset[i] = unItset[i];

	return new ItemSet_t(newItset, unLen);
    }

    void PrintItemset(ostream& fp){
	fp << length << " : ";
    	for (int i = 0; i < length; i++)
	    fp << itemset[i] << " ";
    }

};
#endif // #ifndef _itemset_h


